/*****
 * xscreenshot.c
 * Take screenshot, with selectable area.
 * Copyright (C) James Budiono, 2014
 * License: GNU GPL Version 3 or later.
 *****/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Xregion.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "pnglite.h"


// ***************** Entry point *************
int main (int argc, char*argv[])
{
    Display *display = XOpenDisplay(NULL);
	Window root = DefaultRootWindow (display);
	
	Window root_return, child_return;
	int root_x_return, root_y_return;
	int win_x_return, win_y_return;
	unsigned int mask_return;	

	if (XQueryPointer(display, root, &root_return, &child_return, &root_x_return, &root_y_return, 
                     &win_x_return, &win_y_return, &mask_return) == True)
	{
		Window win = child_return;
		if (win == None) win = root_return;

		// raise it to make sure it is not obscured
		XRaiseWindow(display,win);
		XFlush(display);		

        int x_return, y_return;
        unsigned int width_return, height_return;
        unsigned int border_width_return;
        unsigned int depth_return;
		if (XGetGeometry(display, win, &root_return, &x_return, &y_return, &width_return, 
                      &height_return, &border_width_return, &depth_return) == True) 
        {
			printf("%d %d %d %d %d\n",x_return,y_return,width_return,height_return,border_width_return);
		}
	}

	XFlush (display);
	XCloseDisplay (display);
	return 0;
}

