/******************
 * printdat
 * Prints the binary ipinfo2.dat in text format
 * for comparison with original data file
 * Usage: printdat2 ipinfo.dat 
 * Output: stdout: ipinfo2.dat in text form
 * (C) James Budiono 2013, 2019
 * License: GNU GPL Version 3 or later
 * ****************/
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdint.h>

#include "ipgeocode2.h"

int main (int argc, char *argv[]) {
	struct_ipblock *ipblock;
	struct stat sb_ipinfo;
	int fd_ipinfo;
	uintptr_t i;

	// open files
	if (argc < 2) { fprintf (stderr, "Usage: printdat ipinfo2.dat\n"); exit(1); }
	fd_ipinfo = open(argv[1], O_RDONLY);
	if (fd_ipinfo == -1) handle_error("open ipinfo2");

	if (fstat(fd_ipinfo, &sb_ipinfo) == -1) handle_error("fstat ipinfo2");
	ipblock = mmap(NULL, sb_ipinfo.st_size, PROT_READ, MAP_PRIVATE, fd_ipinfo, 0);
	if (ipblock == MAP_FAILED) handle_error("mmap ipinfo2");

	// ipinfo
	fprintf (stderr, "Re-generating source of %s...\n", argv[1]);
	for (i=0; i < sb_ipinfo.st_size / sizeof (struct_ipblock); i++) {
		fprintf (stdout, "%u %u %.4f %.4f\n", ipblock[i].ipstart, ipblock[i].ipend, ipblock[i].lat, ipblock[i].lng);
	}

	//finish and cleanup  
	munmap (ipblock, sb_ipinfo.st_size); 
	close (fd_ipinfo);
	exit(0);	
}
