/******************
 * geocode pre-processor
 * Reads pre-processed GeoIPLite Block data & convert it to binary ipinfo2.dat
 * Input: ipblock on stdin
 * - ipstart ipend lat long
 * Output: ipinfo2.dat (in current directory)
 * (C) James Budiono 2013, 2019
 * License: GNU GPL Version 3 or later
 * ****************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>

#include "ipgeocode2.h"

#define IPINFO "ipinfo2.dat"

char strbuf[256];

int main (int argc, char *argv[]) {
	struct_ipblock ipblock;
	int fd_ipinfo;
	
	fd_ipinfo = open(IPINFO, O_WRONLY | O_CREAT, 0444 );
	if (fd_ipinfo == -1) handle_error("create ipinfo");
	ftruncate(fd_ipinfo,0);
		
	fprintf (stderr, "Generating " IPINFO "...\n");
	while (fgets (strbuf, sizeof (strbuf), stdin)) {
		sscanf (strbuf, "%u %u %f %f",  &ipblock.ipstart, &ipblock.ipend, &ipblock.lat, &ipblock.lng);
		printf ("%u %u %.4f %.4f\n", ipblock.ipstart, ipblock.ipend, ipblock.lat, ipblock.lng);
		write (fd_ipinfo, &ipblock, sizeof (struct_ipblock));	
	}
	close (fd_ipinfo);
	return 0;
}
