#!/bin/dash
# generate world visitor stat image
# (C) James Budiono 2013, 2019
# License: GNU GPL Version 3 or later.
#
# stdin: ip addresses
# stdout: the output file (jpeg)
# example invocation: awk -F"|"  '{print $1}' online.ppl.uo | sort | uniq | ./genimage2.sh > out.jpg
# dependency: fly (from http://martin.gleeson.com/fly/)

### configuration
export LANG=C
IPINFO_DATA=ipinfo2.dat
IPGEOCODE=./ipgeocode2

MAP_IMAGE=map.png # must be png
MAP_WIDTH=310
MAP_HEIGHT=240
MARK_OUTER_DIA=10 # 5
MARK_INNER_DIA=6  # 3
MARK_OUTER_COLOR=255,0,0
MARK_INNER_COLOR=255,255,0

####### helpers #######

### convert latitude longitude 
# input: stdin (in $1 and $2) and convert it to x,y on map image
latlong_to_xy() {
	awk -v width=$MAP_WIDTH -v height=$MAP_HEIGHT '
	BEGIN {
	### configuration
	# map dimension, in pixel
	#width=310	
	#height=240
	PI=3.141593	
	}

	### latlong_to_xy main
	{
		# $1, $2 is lat (90,-90) and long (-180, 180)
		# convert lat long to pixel coordinate
		x = (($2 + 180) * width) / 360
		factor=1; y=$1; if ($1 < 0) { factor=-1; y = -y; }
		y = y * PI/180; y = ((1+sin(y))/cos(y))
		if (y<0) y = 1e10;
		y = height/2 - (factor*log(y) * width/2 / PI);
		if (y<0) y = 0
		if (y>height) y = height
		print int(x), int(y) 
	}'
}

### mark image
# input: $1 map image, will be updated (must be png)
# stdin: x y where to place markers
mark() {
	{
		echo "existing $1"
		while read x y; do
			echo "fcircle $x,$y,$MARK_OUTER_DIA,$MARK_OUTER_COLOR"
			echo "fcircle $x,$y,$MARK_INNER_DIA,$MARK_INNER_COLOR"
		done
		echo "end"
	} | fly > "${1}.tmp" 2> /dev/null
	mv "${1}.tmp" "$1"
}

########## main ############
TMP_IMAGE=$(mktemp -p /tmp map.XXXXXXXXX)
cp $MAP_IMAGE $TMP_IMAGE

# anything other than GNU grep is slow
# convert ip to location | geocode with grep | convert to x,y | place marker
$IPGEOCODE $IPINFO_DATA | sort | uniq | latlong_to_xy | mark $TMP_IMAGE

# and convert the final png to jpeg (save bandwidth)
pngtopnm < $TMP_IMAGE | pnmtojpeg 
rm $TMP_IMAGE
