#!/bin/dash
# convert GeoLite2 (GeoIP2) City data for usage with ipgeocode2
# (C) James Budiono 2019
# License: GNU GPL Version 3 or later.
# input: $1 - GeoLite2 City CSV
# output: ipinfo2.dat
#

[ $# -lt 1 ] && echo "Usage: ${0##*/} city.csv" && exit

TMP_FILE=$(mktemp -p /tmp XXXXXXXXXX)
awk -F, 'NR != 1 {print $1 " " $2 " " $9 " " $10}' $1 | ./preprocess2 > $TMP_FILE

./printdat2 ipinfo2.dat > $TMP_FILE-2
echo "Validating..."
if ! cmp $TMP_FILE $TMP_FILE-2; then
	echo "Bad news."
else
	echo "ipinfo2.dat ready"
fi
rm $TMP_FILE $TMP_FILE-2
