/******************
 * printdat
 * Prints the binary ipinfo.dat and locinfo.dat in text format
 * for comparison with original data file
 * Usage: printdat ipinfo.dat locinfo.dat
 * Output: stdout: combined ipinfo & locinfo dat in text form,
 * separated by ===###===
 * (C) James Budiono 2013
 * License: GNU GPL Version 3 or later
 * ****************/
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdint.h>

#include "ipgeocode.h"

int main (int argc, char *argv[]) {
	struct_ipblock *ipblock;
	struct_location *loc;
	struct stat sb_ipinfo, sb_locinfo;
	int fd_ipinfo, fd_locinfo;
	uintptr_t i;

	// open files
	if (argc < 3) { fprintf (stderr, "Usage: printdat ipinfo.dat locinfo.dat\n"); exit(1); }
	fd_ipinfo = open(argv[1], O_RDONLY);
	if (fd_ipinfo == -1) handle_error("open ipinfo");
	fd_locinfo = open(argv[2], O_RDONLY);
	if (fd_ipinfo == -1) handle_error("open locinfo");

	if (fstat(fd_ipinfo, &sb_ipinfo) == -1) handle_error("fstat ipinfo");
	ipblock = mmap(NULL, sb_ipinfo.st_size, PROT_READ, MAP_PRIVATE, fd_ipinfo, 0);
	if (ipblock == MAP_FAILED) handle_error("mmap ipblock");

	if (fstat(fd_locinfo, &sb_locinfo) == -1) handle_error("fstat locinfo");
	loc = mmap(NULL, sb_locinfo.st_size, PROT_READ, MAP_PRIVATE, fd_locinfo, 0);
	if (loc == MAP_FAILED) handle_error("mmap ipblock");

	// ipinfo
	fprintf (stderr, "Re-generating source of %s...\n", argv[1]);
	for (i=0; i < sb_ipinfo.st_size / sizeof (struct_ipblock); i++) {
		fprintf (stdout, "%u %u %u\n", ipblock[i].ipstart, ipblock[i].ipend, ipblock[i].location);
	}

	//separator
	fprintf (stdout, SEPARATOR "\n");

	// locinfo
	fprintf (stderr, "Re-generating source of %s...\n", argv[2]);
	for (i=0; i < sb_locinfo.st_size / sizeof (struct_location); i++) {
		fprintf (stdout, "%.*s", loc[i].len, loc[i].latlong);
	}

	//finish and cleanup  
	munmap (ipblock, sb_ipinfo.st_size); 
	munmap (loc, sb_locinfo.st_size); 
	close (fd_ipinfo);
	close (fd_locinfo);
	exit(0);	
}