/******************
 * geocode pre-processor
 * Reads pre-processed GeoIPLite Block data & convert it to binary ipinfo.dat
 * Input: ipblock and location data on stdin
 * - for ipblock: ipstart ipend location-code, one per line
 * - for location: location lat long, one per line
 * - separate iplock and location with ===###===
 * Output: ipinfo.dat locinfo.dat (in current directory)
 * (C) James Budiono 2013
 * License: GNU GPL Version 3 or later
 * ****************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>

#include "ipgeocode.h"

#define IPINFO "ipinfo.dat"
#define LOCINFO "locinfo.dat"

int main (int argc, char *argv[]) {
	char strbuf[256];
	struct_ipblock ipblock;
	struct_location loc;
	int mode;
	int fd_ipinfo, fd_locinfo;
	
	fd_ipinfo = open(IPINFO, O_WRONLY | O_CREAT, 0444 );
	if (fd_ipinfo == -1) handle_error("create ipinfo");
	
	fd_locinfo = open(LOCINFO, O_WRONLY | O_CREAT, 0444 );
	if (fd_locinfo == -1) handle_error("create locinfo");		
	
	mode = 0; //start with ip block
	fprintf (stderr, "Generating " IPINFO "...\n");
	while (fgets (strbuf, sizeof (strbuf), stdin)) {
		if (memcmp (strbuf, SEPARATOR, sizeof (SEPARATOR)-1 ) == 0) {
			mode = 1; //switch to location after this separator
			fprintf (stderr, "Generating " LOCINFO "...\n");
			continue;
		}
		
		switch (mode) {
			case 0:	//pre-process ipblock data
				sscanf (strbuf, "%u %u %u",  &ipblock.ipstart, &ipblock.ipend, &ipblock.location);
				debug_print ("%u %u %u\n", ipblock.ipstart, ipblock.ipend, ipblock.location);
				write (fd_ipinfo, &ipblock, sizeof (struct_ipblock));
				break;
				
			case 1: //pre-process location data
				debug_print ("%s", strbuf);
				loc.len = strlen (strbuf);
				if (loc.len > sizeof (loc.latlong)) loc.len = sizeof (loc.latlong) - 1;
				strncpy (loc.latlong, strbuf, sizeof (loc.latlong));
				write (fd_locinfo, &loc, sizeof (struct_location));
				break;
		}
	
	}
	close (fd_ipinfo);
	close (fd_locinfo);
	return 0;
}
