/* the data structure of geocode.dat */
typedef struct __attribute__ ((packed)) {
	uint32_t ipstart, ipend, location;
} struct_ipblock;

typedef struct __attribute__ ((packed)) {
	uint32_t len;
	char latlong[28]; /* 9 chars for each lat/long + space & spares */
} struct_location;

#define handle_error(msg) \
		do { perror(msg); exit(1); } while (0)

#ifdef DEBUG		
#define debug_print(fmt, ...) \
		do { fprintf(stderr, fmt, __VA_ARGS__); } while (0)
#else
#define debug_print(...)
#endif

#define SEPARATOR "===###==="