#!/bin/dash
# convert GeoIPLite City data for usage with geocode
# (C) James Budiono 2013
# License: GNU GPL Version 3 or later.
# input: $1 - GeoIPLite Blocks, $2 GeoIPLite Location
# output: ipinfo.dat locinfo.dat
#

[ $# -lt 2 ] && echo "Usage: convert.sh block.csv location.csv" && exit

SEPARATOR="===###==="
TMP_FILE=$(mktemp -p /tmp XXXXXXXXXX)
echo Converting, please wait ...
{
	sed '
	/"/ ! d
	s/"//g
	s/,/ /g
	' < "$1" 
	echo $SEPARATOR
	awk -F, '
	{
		if (NR >= 3) print $6, $7
	}' < "$2"
} > $TMP_FILE


./preprocess < $TMP_FILE
./printdat ipinfo.dat locinfo.dat > $TMP_FILE-2
echo "Validating..."
if ! cmp $TMP_FILE $TMP_FILE-2; then
	echo "Bad news."
else
	echo "ipinfo.dat locinfo.dat is ready"
fi
rm $TMP_FILE $TMP_FILE-2
